/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

class BigDecimalValidator
implements Serializable {
    private static final long serialVersionUID = -670320911490506772L;
    private static final BigDecimalValidator VALIDATOR = new BigDecimalValidator();

    BigDecimalValidator() {
    }

    public static BigDecimalValidator getInstance() {
        return VALIDATOR;
    }

    public BigDecimal validate(String value, DecimalFormat format) {
        return (BigDecimal)this.parse(value, format);
    }

    protected Number parse(String value, DecimalFormat formatter) {
        ParsePosition pos = new ParsePosition(0);
        Number parsedValue = formatter.parse(value, pos);
        if (pos.getErrorIndex() > -1) {
            return null;
        }
        if (pos.getIndex() < value.length()) {
            return null;
        }
        if (parsedValue != null) {
            if (Double.isInfinite(parsedValue.doubleValue())) {
                return null;
            }
            parsedValue = this.processParsedValue(parsedValue, formatter);
        }
        return parsedValue;
    }

    protected BigDecimal processParsedValue(Number value, DecimalFormat formatter) {
        BigDecimal decimal = value instanceof Long ? BigDecimal.valueOf((Long)value) : new BigDecimal(value.toString());
        int scale = this.determineScale(formatter);
        if (scale >= 0) {
            decimal = decimal.setScale(scale, RoundingMode.DOWN);
        }
        return decimal;
    }

    protected int determineScale(NumberFormat format) {
        int maximumFraction;
        int minimumFraction = format.getMinimumFractionDigits();
        if (minimumFraction != (maximumFraction = format.getMaximumFractionDigits())) {
            return -1;
        }
        int scale = minimumFraction;
        if (format instanceof DecimalFormat) {
            int multiplier = ((DecimalFormat)format).getMultiplier();
            if (multiplier == 100) {
                scale += 2;
            } else if (multiplier == 1000) {
                scale += 3;
            }
        }
        return scale;
    }
}

