/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.component.fileupload.FileUploadChunkDecoder;
import org.primefaces.component.fileupload.FileUploadDecoder;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.shaded.commons.io.FilenameUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.virusscan.VirusException;

public class FileUploadUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUploadUtils.class.getName());
    private static final String FILENAME_EMPTY = "primefaces.FileValidator.FILENAME_EMPTY";
    private static final String FILENAME_INVALID_CHAR = "primefaces.FileValidator.FILENAME_INVALID_CHAR";
    private static final String FILENAME_INVALID_WINDOWS = "primefaces.FileValidator.FILENAME_INVALID_WINDOWS";
    private static final String FILENAME_INVALID_LINUX = "primefaces.FileValidator.FILENAME_INVALID_LINUX";
    private static final Pattern INVALID_FILENAME_WINDOWS = Pattern.compile("^(?!^(PRN|AUX|CLOCK\\$|NUL|CON|COM\\d|LPT\\d|\\..*)(\\..+)?$)[^\\x00-\\x1f\\\\?*:\\\";|/<>]+$");
    private static final Pattern INVALID_FILENAME_LINUX = Pattern.compile(".*[/\u0000:*?\\\"<>|].*");
    private static final Pattern ENCODED_CHARS_PAT = Pattern.compile("(%)([0-9a-fA-F])([0-9a-fA-F])");

    private FileUploadUtils() {
    }

    public static String requireValidFilename(FacesContext context, String filename) {
        Matcher encodedMatcher;
        if (LangUtils.isBlank(filename)) {
            throw FileUploadUtils.validationError(MessageFactory.getMessage(context, FILENAME_EMPTY, new Object[0]));
        }
        Character ch = FileUploadUtils.containsInvalidCharacters(filename);
        if (ch != null) {
            throw FileUploadUtils.validationError(MessageFactory.getMessage(context, FILENAME_INVALID_CHAR, filename, ch));
        }
        if (FileUploadUtils.isSystemWindows()) {
            if (!INVALID_FILENAME_WINDOWS.matcher(filename).find()) {
                throw FileUploadUtils.validationError(MessageFactory.getMessage(context, FILENAME_INVALID_WINDOWS, filename));
            }
        } else if (INVALID_FILENAME_LINUX.matcher(filename).find()) {
            throw FileUploadUtils.validationError(MessageFactory.getMessage(context, FILENAME_INVALID_LINUX, filename));
        }
        if ((encodedMatcher = ENCODED_CHARS_PAT.matcher(filename)).find()) {
            throw FileUploadUtils.validationError(MessageFactory.getMessage(context, FILENAME_INVALID_CHAR, filename, encodedMatcher.group()));
        }
        return FilenameUtils.getName(filename);
    }

    public static String requireValidFilePath(String filePath, boolean mustExist) {
        if (LangUtils.isBlank(filePath)) {
            throw FileUploadUtils.validationError("Path can not be the empty string or null");
        }
        Character ch = FileUploadUtils.containsInvalidCharacters(filePath);
        if (ch != null) {
            throw FileUploadUtils.validationError("Invalid path: (" + filePath + ") contains invalid character: " + ch);
        }
        filePath = URLDecoder.decode(filePath, StandardCharsets.UTF_8);
        if (FileUploadUtils.isSystemWindows()) {
            filePath = filePath.replace("/", "\\");
        }
        try {
            File file = new File(filePath);
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                throw FileUploadUtils.validationError("Invalid directory, \"" + filePath + "\" is not valid.");
            }
            if (mustExist && !file.exists()) {
                throw FileUploadUtils.validationError("Invalid file, \"" + String.valueOf(file) + "\" does not exist.");
            }
            if (mustExist && !parentFile.exists()) {
                throw FileUploadUtils.validationError("Invalid directory, file parent directory does not exist.");
            }
            if (mustExist && !parentFile.isDirectory()) {
                throw FileUploadUtils.validationError("Invalid directory, file parent is not a directory.");
            }
            if (!file.getCanonicalFile().toPath().startsWith(parentFile.getCanonicalFile().toPath())) {
                throw FileUploadUtils.validationError("Invalid directory, \"" + String.valueOf(file) + "\" does not reside inside specified parent.");
            }
            if (!file.getCanonicalPath().equals(filePath)) {
                throw FileUploadUtils.validationError("Invalid directory, name does not match the canonical path.");
            }
        }
        catch (IOException ex) {
            throw FileUploadUtils.validationError("Failure to validate directory path: " + ex.getMessage());
        }
        return filePath;
    }

    public static ValidatorException validationError(String message) {
        return new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "File Error", message));
    }

    static boolean isSystemWindows() {
        return File.separatorChar == '\\';
    }

    public static Character containsInvalidCharacters(String s) {
        block2: {
            try {
                Paths.get(s, new String[0]);
            }
            catch (InvalidPathException e) {
                if (e.getInput() == null || e.getInput().isEmpty() || e.getIndex() < 0) break block2;
                return Character.valueOf(s.toCharArray()[e.getIndex()]);
            }
        }
        return null;
    }

    public static boolean isValidType(PrimeApplicationContext context, UploadedFile uploadedFile, String allowTypes, String accept) {
        boolean bl;
        block10: {
            String fileName = uploadedFile.getFileName();
            InputStream input = uploadedFile.getInputStream();
            try {
                boolean validType;
                boolean bl2 = validType = FileUploadUtils.isValidFileName(uploadedFile, allowTypes) && FileUploadUtils.isValidFileContent(context, accept, fileName, input);
                if (validType && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("The uploaded file %s meets the filename and content type specifications", fileName));
                }
                bl = validType;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, String.format("The type of the uploaded file %s could not be validated", fileName), ex);
                    }
                    return false;
                }
            }
            input.close();
        }
        return bl;
    }

    private static boolean isValidFileName(UploadedFile uploadedFile, String javascriptRegex) {
        boolean isValid;
        if (LangUtils.isBlank(javascriptRegex)) {
            return true;
        }
        String javaRegex = FileUploadUtils.convertJavaScriptRegex(javascriptRegex);
        if (LangUtils.isBlank(javaRegex)) {
            return true;
        }
        String fileName = EscapeUtils.forJavaScriptAttribute(uploadedFile.getFileName());
        String contentType = EscapeUtils.forJavaScriptAttribute(uploadedFile.getContentType());
        Pattern allowTypesPattern = Pattern.compile(javaRegex, 66);
        Matcher fileNameMatcher = allowTypesPattern.matcher(fileName);
        Matcher contentTypeMatcher = allowTypesPattern.matcher(contentType);
        boolean bl = isValid = fileNameMatcher.find() || contentTypeMatcher.find();
        if (!isValid) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(String.format("The uploaded filename %s does not match the specified regex %s", fileName, javaRegex));
            }
            return false;
        }
        return true;
    }

    protected static String convertJavaScriptRegex(String jsRegex) {
        char endChar;
        int start = 0;
        int end = jsRegex.length() - 1;
        if (jsRegex.charAt(0) == '/') {
            start = 1;
        }
        if ((endChar = jsRegex.charAt(end)) == 'i' || endChar == 'g') {
            --end;
        }
        return LangUtils.substring(jsRegex, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidFileContent(PrimeApplicationContext primeAppContext, String allowedContentTypes, String fileName, InputStream stream) throws IOException {
        String contentType;
        if (LangUtils.isBlank(allowedContentTypes)) {
            return true;
        }
        String prefix = FilenameUtils.removeExtension(fileName);
        Path tempFile = Files.createTempFile(prefix, "", new FileAttribute[0]);
        try (PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(stream));
             OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            String extension;
            IOUtils.copyLarge(in, out);
            contentType = primeAppContext.getFileTypeDetector().probeContentType(tempFile);
            if (contentType == null && !(extension = FilenameUtils.getExtension(fileName)).isEmpty()) {
                String newFileName = tempFile.getFileName().toString() + "." + extension;
                tempFile = Files.move(tempFile, tempFile.resolveSibling(newFileName), new CopyOption[0]);
                contentType = primeAppContext.getFileTypeDetector().probeContentType(tempFile);
            }
        }
        finally {
            FileUploadUtils.deleteFile(tempFile);
        }
        if (contentType == null) {
            LOGGER.log(Level.WARNING, () -> String.format("Could not determine content type of uploaded file %s", fileName));
            return false;
        }
        String filenameLC = fileName.toLowerCase();
        String contentTypeLC = contentType.toLowerCase();
        boolean accepted = Stream.of(allowedContentTypes.split(",")).map(String::trim).anyMatch(allowedContentType -> {
            if (allowedContentType.startsWith(".") && filenameLC.endsWith((String)allowedContentType)) {
                LOGGER.log(Level.FINE, () -> String.format("File extension %s of the uploaded file %s is accepted", allowedContentType, fileName));
                return true;
            }
            if (FilenameUtils.wildcardMatch(contentTypeLC, allowedContentType)) {
                LOGGER.log(Level.FINE, () -> String.format("Content type %s of the uploaded file %s is accepted by %s", contentTypeLC, fileName, allowedContentType));
                return true;
            }
            return false;
        });
        if (!accepted) {
            LOGGER.log(Level.FINE, () -> String.format("Uploaded file %s with content type %s does not match the accept specification %s", fileName, contentTypeLC, allowedContentTypes));
            return false;
        }
        return true;
    }

    private static void deleteFile(Path tempFile) {
        try {
            Files.delete(tempFile);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex, () -> String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()));
            try {
                tempFile.toFile().deleteOnExit();
            }
            catch (Exception ex1) {
                LOGGER.log(Level.WARNING, ex1, () -> String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()));
            }
        }
    }

    public static void performVirusScan(FacesContext facesContext, UploadedFile file) throws VirusException {
        PrimeApplicationContext.getCurrentInstance(facesContext).getVirusScannerService().performVirusScan(file);
    }

    public static List<Path> listChunks(Path path) {
        List<Path> list;
        block8: {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                list = walk.filter(p -> p.toFile().isFile() && p.getFileName().toString().matches("\\d+")).sorted(Comparator.comparing(p -> Long.parseLong(p.getFileName().toString()))).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SecurityException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            walk.close();
        }
        return list;
    }

    public static <T extends HttpServletRequest> List<Path> listChunks(T request) {
        Path chunkDir = FileUploadUtils.getChunkDir(request);
        if (!chunkDir.toFile().exists()) {
            return Collections.emptyList();
        }
        return FileUploadUtils.listChunks(chunkDir);
    }

    public static <T extends HttpServletRequest> FileUploadChunkDecoder<T> getFileUploadChunkDecoder(T request) {
        PrimeApplicationContext pfContext = PrimeApplicationContext.getCurrentInstance(request.getServletContext());
        FileUploadDecoder decoder = pfContext.getFileUploadDecoder();
        if (!(decoder instanceof FileUploadChunkDecoder)) {
            throw new FacesException("Chunk decoder not supported");
        }
        return (FileUploadChunkDecoder)((Object)decoder);
    }

    public static <T extends HttpServletRequest> Path getChunkDir(T request) {
        FileUploadChunkDecoder<T> chunkDecoder = FileUploadUtils.getFileUploadChunkDecoder(request);
        String fileKey = chunkDecoder.generateFileInfoKey(request);
        return Paths.get(chunkDecoder.getUploadDirectory(request), fileKey);
    }

    public static <T extends HttpServletRequest> String getWebkitRelativePath(T request) {
        return request.getParameter("X-File-Webkit-Relative-Path");
    }

    public static String formatAllowTypes(String allowTypes) {
        return allowTypes != null ? allowTypes.replace("/(\\.|\\/)(", "").replace(")$/", "") : null;
    }

    public static String formatBytes(Long bytes, Locale locale) {
        if (bytes == null) {
            return "";
        }
        if (bytes == 0L) {
            return "N/A";
        }
        String[] sizes = new String[]{"Bytes", "KB", "MB", "GB", "TB"};
        int i = (int)Math.floor(Math.log(bytes.longValue()) / Math.log(1024.0));
        if (i == 0) {
            return bytes + " " + sizes[i];
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(locale));
        return decimalFormat.format((double)bytes.longValue() / Math.pow(1024.0, i)) + " " + sizes[i];
    }
}

