/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.validate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.Part;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.file.NativeUploadedFile;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFiles;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.validate.ClientValidator;
import org.primefaces.validate.base.AbstractPrimeValidator;
import org.primefaces.virusscan.VirusException;

public class FileValidator
extends AbstractPrimeValidator
implements ClientValidator {
    public static final String VALIDATOR_ID = "primefaces.File";
    public static final String FILE_LIMIT_MESSAGE_ID = "primefaces.FileValidator.FILE_LIMIT";
    public static final String ALLOW_TYPES_MESSAGE_ID = "primefaces.FileValidator.ALLOW_TYPES";
    public static final String SIZE_LIMIT_MESSAGE_ID = "primefaces.FileValidator.SIZE_LIMIT";

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (component instanceof FileUpload) {
            String accept;
            String string = accept = Boolean.TRUE.equals(this.getContentType()) ? ((FileUpload)component).getAccept() : null;
            if (value instanceof UploadedFile) {
                UploadedFile uploadedFile = (UploadedFile)value;
                this.validateUploadedFile(context, uploadedFile, accept);
            } else if (value instanceof UploadedFiles) {
                UploadedFiles uploadedFiles = (UploadedFiles)value;
                this.validateUploadedFiles(context, uploadedFiles, accept);
            } else if (value != null) {
                throw new IllegalArgumentException("Argument of type '" + value.getClass().getName() + "' not supported");
            }
        } else if (component instanceof HtmlInputFile) {
            String accept;
            String string = accept = Boolean.TRUE.equals(this.getContentType()) ? (String)component.getAttributes().get("accept") : null;
            if (value instanceof Part) {
                NativeUploadedFile uploadedFile = new NativeUploadedFile((Part)value, this.getSizeLimit(), null);
                this.validateUploadedFile(context, uploadedFile, accept);
            } else if (value instanceof List) {
                List<UploadedFile> uploadedFiles = ((List)value).stream().map(part -> new NativeUploadedFile((Part)part, this.getSizeLimit(), null)).collect(Collectors.toList());
                this.validateUploadedFiles(context, new UploadedFiles(uploadedFiles), accept);
            } else if (value != null) {
                throw new IllegalArgumentException("Argument of type '" + value.getClass().getName() + "' not supported");
            }
        } else {
            throw new IllegalArgumentException("Component of type '" + String.valueOf(component.getClass()) + "' not supported");
        }
    }

    protected void validateUploadedFiles(FacesContext context, UploadedFiles uploadedFiles, String accept) {
        Integer fileLimit = this.getFileLimit();
        if (fileLimit != null && uploadedFiles.getFiles().size() > fileLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage(context, FILE_LIMIT_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, fileLimit));
        }
        long totalSize = 0L;
        for (UploadedFile file : uploadedFiles.getFiles()) {
            totalSize += file.getSize();
            this.validateUploadedFile(context, file, accept);
        }
        Long sizeLimit = this.getSizeLimit();
        if (sizeLimit != null && totalSize > sizeLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage(context, SIZE_LIMIT_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, "*", FileUploadUtils.formatBytes(sizeLimit, LocaleUtils.getCurrentLocale(context))));
        }
    }

    protected void validateUploadedFile(FacesContext context, UploadedFile uploadedFile, String accept) {
        PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
        Long sizeLimit = this.getSizeLimit();
        if (sizeLimit != null && uploadedFile.getSize() > sizeLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage(context, SIZE_LIMIT_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, uploadedFile.getFileName(), FileUploadUtils.formatBytes(sizeLimit, LocaleUtils.getCurrentLocale(context))));
        }
        String allowTypes = this.getAllowTypes();
        if (!FileUploadUtils.isValidType(applicationContext, uploadedFile, allowTypes, accept)) {
            throw new ValidatorException(MessageFactory.getFacesMessage(context, ALLOW_TYPES_MESSAGE_ID, FacesMessage.SEVERITY_ERROR, uploadedFile.getFileName(), FileUploadUtils.formatAllowTypes(allowTypes)));
        }
        if (Boolean.TRUE.equals(this.getVirusScan())) {
            try {
                PrimeApplicationContext.getCurrentInstance(context).getVirusScannerService().performVirusScan(uploadedFile);
            }
            catch (VirusException e) {
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), ""), (Throwable)((Object)e));
            }
        }
    }

    @Override
    public Map<String, Object> getMetadata() {
        String allowTypes;
        Long sizeLimit;
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        Integer fileLimit = this.getFileLimit();
        if (fileLimit != null) {
            metadata.put("data-p-filelimit", fileLimit);
        }
        if ((sizeLimit = this.getSizeLimit()) != null) {
            metadata.put("data-p-sizelimit", sizeLimit);
        }
        if (LangUtils.isNotBlank(allowTypes = this.getAllowTypes())) {
            metadata.put("data-p-allowtypes", allowTypes);
        }
        return metadata;
    }

    @Override
    public String getValidatorId() {
        return VALIDATOR_ID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileValidator that = (FileValidator)o;
        return Objects.equals(this.getStateHelper(), that.getStateHelper());
    }

    public int hashCode() {
        return Objects.hash(this.getStateHelper());
    }

    public Integer getFileLimit() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.fileLimit), null);
    }

    public void setFileLimit(Integer fileLimit) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.fileLimit), (Object)fileLimit);
    }

    public Long getSizeLimit() {
        return (Long)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.sizeLimit), null);
    }

    public void setSizeLimit(Long sizeLimit) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sizeLimit), (Object)sizeLimit);
    }

    public String getAllowTypes() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.allowTypes), null);
    }

    public void setAllowTypes(String allowTypes) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.allowTypes), (Object)allowTypes);
    }

    public Boolean getContentType() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.contentType), null);
    }

    public void setContentType(Boolean contentType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.contentType), (Object)contentType);
    }

    public Boolean getVirusScan() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.virusScan), null);
    }

    public void setVirusScan(Boolean virusScan) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.virusScan), (Object)virusScan);
    }

    public static enum PropertyKeys {
        allowTypes,
        fileLimit,
        sizeLimit,
        contentType,
        virusScan;

    }
}

