/*
 * Copyright 2009-2013 PrimeTek.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.util;

public class Constants {

    public class ContextParams {
        // JSF context params
        public static final String INTERPRET_EMPTY_STRING_AS_NULL = "javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL";
        
        // PF context params
        public static final String THEME = "primefaces.THEME";
        public static final String AUTO_UPDATE = "primefaces.AUTO_UPDATE";
        public static final String PUSH_SERVER_URL = "primefaces.PUSH_SERVER_URL";
        public static final String SUBMIT = "primefaces.SUBMIT";
        public static final String DIRECTION = "primefaces.DIR";
        public static final String RESET_VALUES = "primefaces.RESET_VALUES";
        public static final String SECRET_KEY = "primefaces.SECRET";
        public static final String PFV_KEY = "primefaces.CLIENT_SIDE_VALIDATION";
        public static final String UPLOADER = "primefaces.UPLOADER";
    }

    public class RequestParams {
        // JSF request params
        public static final String PARTIAL_REQUEST_PARAM = "javax.faces.partial.ajax";
        public static final String PARTIAL_UPDATE_PARAM = "javax.faces.partial.render";
        public static final String PARTIAL_PROCESS_PARAM = "javax.faces.partial.execute";
        public static final String PARTIAL_SOURCE_PARAM = "javax.faces.source";
        public static final String PARTIAL_BEHAVIOR_EVENT_PARAM = "javax.faces.behavior.event";

        // PF request params
        public static final String RESET_VALUES_PARAM = "primefaces.resetvalues";
        public static final String IGNORE_AUTO_UPDATE_PARAM = "primefaces.ignoreautoupdate";
    }

    public static final String DOWNLOAD_COOKIE = "primefaces.download";

    public final static String LIBRARY = "primefaces";

    public final static String CUSTOM_EVENT = "CUSTOM_EVENT";
    
    public final static String PUSH_PATH = "/primepush";
    
    public static final String DYNAMIC_CONTENT_PARAM = "pfdrid";
    public static final String DYNAMIC_CONTENT_CACHE_PARAM = "pfdrid_c";

    public final static String FRAGMENT_ID = "primefaces.fragment";
    public final static String FRAGMENT_AUTO_RENDERED = "primefaces.fragment.autorendered";
    
    public final static String DIALOG_OUTCOME = "dialog.outcome";
    public final static String DIALOG_OPTIONS = "dialog.options";
    public final static String DIALOG_PARAMS = "dialog.params";
    public final static String DIALOG_SOURCE_COMPONENT = "dialog.source.component";
    public final static String DIALOG_SOURCE_WIDGET = "dialog.source.widget";
    public final static String DIALOG_CONVERSATION_PARAM = "pfdlgcid";
}
