/*
 * Copyright 2009-2014 PrimeTek.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.metadata;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import org.primefaces.context.RequestContext;

public abstract class ComponentMetadataTransformer {
    
    public abstract void transform(FacesContext context, RequestContext requestContext, UIComponent component) throws IOException;
    
    protected void setMaxlength(UIInput input, int maxlength) {
        if (input instanceof HtmlInputText) {
            ((HtmlInputText) input).setMaxlength(maxlength);
        }
        else if (input instanceof HtmlInputSecret) {
            ((HtmlInputSecret) input).setMaxlength(maxlength);
        }
    }
    
    protected int getMaxlength(UIInput input) {
        if (input instanceof HtmlInputText) {
            return ((HtmlInputText) input).getMaxlength();
        }
        else if (input instanceof HtmlInputSecret) {
            return ((HtmlInputSecret) input).getMaxlength();
        }
        
        return Integer.MIN_VALUE;
    }
    
    protected boolean isMaxlenghtSet(UIInput input) {
        return getMaxlength(input) != Integer.MIN_VALUE;
    }
}
