/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.stilts.stomp.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.projectodd.stilts.stomp.DefaultHeaders;
import org.projectodd.stilts.stomp.Headers;
import org.projectodd.stilts.stomp.StompException;
import org.projectodd.stilts.stomp.Subscription;
import org.projectodd.stilts.stomp.client.ClientSubscription;
import org.projectodd.stilts.stomp.client.MessageHandler;
import org.projectodd.stilts.stomp.client.StompClient;
import org.projectodd.stilts.stomp.client.SubscriptionBuilder;

class SubscriptionBuilderImpl
implements SubscriptionBuilder {
    private final StompClient client;
    private Headers headers;
    private MessageHandler messageHandler;
    private Executor executor;

    SubscriptionBuilderImpl(StompClient client, String destination) {
        this.client = client;
        this.headers = new DefaultHeaders();
        this.headers.put("destination", destination);
    }

    @Override
    public SubscriptionBuilder withMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public SubscriptionBuilder withSelector(String selector) {
        this.headers.put("selector", selector);
        return this;
    }

    @Override
    public SubscriptionBuilder withHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
        return this;
    }

    Headers getHeaders() {
        return this.headers;
    }

    @Override
    public SubscriptionBuilder withAckMode(Subscription.AckMode ackMode) {
        this.headers.put("ack", ackMode.toString());
        return this;
    }

    @Override
    public SubscriptionBuilder withExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    Executor getExecutor() {
        return this.executor;
    }

    @Override
    public ClientSubscription start() throws StompException {
        try {
            return this.client.subscribe(this);
        }
        catch (InterruptedException e) {
            throw new StompException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new StompException((Throwable)e);
        }
    }
}

