/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.jms;

import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import javax.naming.InitialContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.jobs.ee.jms.JmsHelper;
import org.quartz.jobs.ee.jms.JmsMessageFactory;

public final class SendTopicMessageJob
implements Job {
    public void execute(JobExecutionContext jobCtx) throws JobExecutionException {
        TopicConnection conn = null;
        TopicSession sess = null;
        TopicPublisher publisher = null;
        try {
            JobDataMap dataMap = jobCtx.getMergedJobDataMap();
            InitialContext namingCtx = JmsHelper.getInitialContext(dataMap);
            TopicConnectionFactory connFactory = (TopicConnectionFactory)namingCtx.lookup(dataMap.getString("jms.connection.factory"));
            if (!JmsHelper.isDestinationSecure(dataMap)) {
                conn = connFactory.createTopicConnection();
            } else {
                String user = dataMap.getString("jms.user");
                String password = dataMap.getString("jms.password");
                conn = connFactory.createTopicConnection(user, password);
            }
            boolean useTransaction = JmsHelper.useTransaction(dataMap);
            int ackMode = dataMap.getInt("jms.acknowledge");
            sess = conn.createTopicSession(useTransaction, ackMode);
            Topic topic = (Topic)namingCtx.lookup(dataMap.getString("jms.destination"));
            publisher = sess.createPublisher(topic);
            JmsMessageFactory messageFactory = JmsHelper.getMessageFactory(dataMap.getString("jms.message.factory.class.name"));
            Message msg = messageFactory.createMessage(dataMap, (Session)sess);
            publisher.publish(msg);
        }
        catch (Exception e) {
            try {
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable throwable) {
                JmsHelper.closeResource(publisher);
                JmsHelper.closeResource(sess);
                JmsHelper.closeResource(conn);
                throw throwable;
            }
        }
        JmsHelper.closeResource(publisher);
        JmsHelper.closeResource(sess);
        JmsHelper.closeResource(conn);
    }
}

