/*
 * $Id: IAcceleratorKeyCapability.java,v 1.4 2006/12/13 14:09:12 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * A string that indicates the (composed) key used to execute an action from the keyboard.
 * <p>
 * [Shift|Alt|Ctrl] + &lt;Any key&gt;
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/13 14:09:12 $
 */
public interface IAcceleratorKeyCapability {
    
	/**
	 * Returns a string that indicates the (composed) key used to execute an action from the keyboard.
	 * 
	 * @return [Shift|Alt|Ctrl] + &lt;Any key&gt;
	 */
	String getAcceleratorKey();

	/**
	 * Sets a string that indicates the (composed) key used to execute an action from the keyboard.
	 * 
	 * @param acceleratorKey [Shift|Alt|Ctrl] + &lt;Any key&gt;
	 */
	void setAcceleratorKey(String acceleratorKey);
}
