/*
 * $Id: IAccessKeyCapability.java,v 1.5 2006/12/13 14:09:12 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * A string that indicates the alphanumeric key used to execute an action from the keyboard (in conjunction with a alteration key ex : Alt).
 * <p>
 * Alt + &lt;Any alphanumeric key&gt;
 * <BR>The letter|number will be highlighted when the alteration key is pressed.
 * </p>
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/13 14:09:12 $
 */
public interface IAccessKeyCapability {
	/**
	 * Returns a string that indicates the alphanumeric key used to execute an action from the keyboard (in conjunction with a alteration key ex : Alt).
	 * 
	 * @return &lt;Any alphanumeric key&gt;
	 */
	String getAccessKey();

	/**
	 * Sets a string that indicates the alphanumeric key used to execute an action from the keyboard (in conjunction with a alteration key ex : Alt).
	 * 
	 * @param key &lt;Any alphanumeric key&gt;
	 */
	void setAccessKey(String key);
}