/*
 * $Id: IAlignmentCapability.java,v 1.5 2006/12/13 14:09:12 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * A string that represents the alignement of the data in the component.
 * <ul><li>
 * left
 * </li><li>
 * right
 * </li><li>
 * center
 * </li></ul>
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/13 14:09:12 $
 */
public interface IAlignmentCapability {

	/**
	 * Returns a string that represents the alignement of the data in the component.
	 * 
	 * @return right|left|center
	 */
	String getAlignment();

	/**
	 * Sets a string that represents the alignement of the data in the component.
	 * 
	 * @param textAlignment right|left|center
	 */
	void setAlignment(String textAlignment);
}