/*
 * $Id: IAutoTabCapability.java,v 1.4 2006/12/13 14:09:12 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * A boolean value indicating if the focus should move automatically to the next element when the entry is completed.
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/13 14:09:12 $
 */
public interface IAutoTabCapability {
    
	/**
	 * Returns a boolean value indicating if the focus should move automatically to the next element when the entry is completed.
	 * 
	 * @return boolean
	 */
	boolean isAutoTab();

    /**
	 * Sets a boolean value indicating if the focus should move automatically to the next element when the entry is completed.
	 * 
	 * @param autoTab boolean
	 */
    void setAutoTab(boolean autoTab);
}
