/*
 * $Id: IBundleVarCapability.java,v 1.2 2006/12/13 14:09:12 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * A string value specifying the name of a request scope attribute under which the resource bundle will be exposed as a Map. 
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.2 $ $Date: 2006/12/13 14:09:12 $
 */
public interface IBundleVarCapability {
    
	/**
	 * Returns a string value specifying the name of a request scope attribute under which the resource bundle will be exposed as a Map. 
	 * 
	 * @return bundle var name
	 */
	String getBundleVar();

    /**
     * Sets a string value specifying the name of a request scope attribute under which the resource bundle will be exposed as a Map. 
     * 
     * @param bundleVar bundle var name
     */
	void setBundleVar(String bundleVar);
}
