/*
 * $Id: ICheckCardinalityCapability.java,v 1.4 2006/12/13 17:52:29 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

/**
 * An int value indicating the cardinality (number of check allowed) for this componenent.
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/13 17:52:29 $
 */
public interface ICheckCardinalityCapability extends ICardinality {
	
	/**
	 * Returns an int value indicating the cardinality (number of check allowed) for this componenent.
	 * 
	 * @return 1:?,optional|2:*,zeroMany|3:1,one+|4:+,oneMany
	 */
	int getCheckCardinality();
	
	/**
	 * Sets an int value indicating the cardinality (number of check allowed) for this componenent.
	 * 
	 * @param checkCardinality 1:?,optional|2:*,zeroMany|3:1,one+|4:+,oneMany default=zeroMany
	 */
	void setCheckCardinality(int checkCardinality);
}
