/*
 * $Id: ICheckEventCapability.java,v 1.5 2006/12/13 17:52:29 flefevere Exp $
 * 
 */

package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.ICheckListener;


/**
 * 
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/13 17:52:29 $
 */
public interface ICheckEventCapability {

	/**
	 * Adds a listener to the component for the checked event
	 * 
	 * @param checkListener the listener to add
	 */
	void addCheckListener(ICheckListener checkListener);

	/**
	 * Removes a listener from the list of listeners
	 * 
	 * @param checkListener the listener to remove
	 */
	void removeCheckListener(ICheckListener checkListener);

	/**
	 * Returns the list of check listener for the component
	 * @return check listeners' list
	 */
	FacesListener[] listCheckListeners();
}
