/*
 * $Id: ICloseEventCapability.java,v 1.4 2006/12/13 17:52:29 flefevere Exp $
 * 
 */

package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.ICloseListener;


/**
 * 
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/13 17:52:29 $
 */
public interface ICloseEventCapability {

	/**
	 * Adds a listener to the component for the close event
	 * 
	 * @param facesListener the close listener to add
	 */
	void addCloseListener(ICloseListener facesListener);

	/**
	 * Removes a listener from the component for the close event
	 * 
	 * @param facesListener the close listener to remove
	 */
	void removeCloseListener(ICloseListener facesListener);

	/**
	 * Returns a list of close listener for the component
	 * 
	 * @return close listeners' list
	 */
	FacesListener [] listCloseListeners();
}
