/*
 * $Id: IDataSourceCapability.java,v 1.4 2006/12/13 17:52:29 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

/**
 * A component that implements this interface would accept a dataSource reference as a supply of data.
 * 
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/13 17:52:29 $
 */
public interface IDataSourceCapability {

	/**
	 * Sets a dataSource for the component.
	 * 
	 * @param dataSource reference to a dataSource
	 */
	void setDataSource(String dataSource);

	/**
	 * Returns the component's dataSource.
	 * 
	 * @return a reference to the dataSource
	 */
	String getDataSource();
}
