/*
 * $Id: IFilterCapability.java,v 1.4 2006/12/13 17:52:29 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

import org.rcfaces.core.model.IFilterProperties;

/**
 * An object that represent the filter to use on the server side.
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/13 17:52:29 $
 */
public interface IFilterCapability {
    
	/**
	 * Return an object that represent the filter to use on the server side.
	 * 
	 * @return filter
	 */
	IFilterProperties getFilterProperties();

	/**
	 * Sets an object that represent the filter to use on the server side.
	 * 
	 * @param properties filter
	 */
    void setFilterProperties(IFilterProperties properties);
}
