/*
 * $Id: IHelpCapability.java,v 1.5 2006/12/14 16:59:34 flefevere Exp $
 * 
 */

package org.rcfaces.core.component.capability;

/**
 *
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/14 16:59:34 $
 */
public interface IHelpCapability extends IToolTipCapability {

	/**
	 * Returns a string value specifying the message to be shown by a <a href="/comps/helpMessageZoneComponent.html">helpMessageZone Component</a>.
	 * @return help message
	 */
	String getHelpMessage();

	/**
	 * Sets a string value specifying the message to be shown by a <a href="/comps/helpMessageZoneComponent.html">helpMessageZone Component</a>.
	 * @param message help message
	 */
	void setHelpMessage(String message);

	/**
	 * Returns an URL that points to a help page for the component. it is used for example by a <a href="/comps/helpButtonComponent.html">helpButton Component</a>.
	 * @return help url
	 */
	String getHelpURL();

	/**
	 * Sets an URL that points to a help page for the component. it is used for example by a <a href="/comps/helpButtonComponent.html">helpButton Component</a>.
	 * @param url help url
	 */
	void setHelpURL(String url);
}
