/*
 * $Id: IHorizontalTextPositionCapability.java,v 1.3 2006/12/14 16:59:34 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

/**
 * A string value specifying the position of the text in the component :
 * <ul><li>
 * left
 * 		</li><li>
 * 		right
 * 		</li></ul>
 * @author Fred
 *
 */
public interface IHorizontalTextPositionCapability {
    
    int RIGHT_POSITION = 0x00;

    int LEFT_POSITION = 0x10;

    int DEFAULT_POSITION = RIGHT_POSITION;

    /**
     * Returns an int value specifying the position of the text in the component.
     * @return 0x00:right|0x10:left
     */
    int getTextPosition();

    /**
     * Sets an int value specifying the position of the text in the component.
     * @param position 0x00:right|0x10:left
     */
    void setTextPosition(int position);
}
