/*
 * $Id: IImageCapability.java,v 1.3 2006/11/09 19:09:09 oeuillot Exp $
 */
package org.rcfaces.core.component.capability;

import org.rcfaces.core.component.familly.IContentAccessors;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/09 19:09:09 $
 */
public interface IImageCapability {

    /**
     * Returns the URL of the image.
     */
    String getImageURL();

    /**
     * Specify the URL of the image.
     */
    void setImageURL(String url);

    /**
     * Returns ImageAccessors associated to the url. (or java.awt.Image binding)
     * 
     * @return IImageAccessors object.
     */
    IContentAccessors getImageAccessors();
}