/*
 * $Id: IImmediateCapability.java,v 1.4 2006/12/14 16:59:33 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

/**
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/14 16:59:33 $
 */
public interface IImmediateCapability {
	
	/**
	 * Returns a boolean value indicating that this component's value must be
	 * converted and validated immediately (that is, during Apply Request Values phase), 
	 * rather than waiting until Process Validations phase.
	 * @return boolean
	 */
	boolean isImmediate();
	
	/**
	 * Sets a boolean value indicating that this component's value must be
	 * converted and validated immediately (that is, during Apply Request Values phase), 
	 * rather than waiting until Process Validations phase.
	 * @param immediate boolean
	 */
	void setImmediate(boolean immediate);
}
