/*
 * $Id: IKeyPressEventCapability.java,v 1.4 2006/12/14 16:59:34 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.IKeyPressListener;


/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/14 16:59:34 $
 */
public interface IKeyPressEventCapability {

	/**
	 * Adds a listener to the component for the keyPress event
	 * 
	 * @param facesListener the keyPress listener to add 
	 */
    void addKeyPressListener(IKeyPressListener facesListener);

	/**
	 * Removes a listener from the component for the keyPress event
	 * 
	 * @param facesListener the keyPress listener to remove
	 */
    void removeKeyPressListener(IKeyPressListener facesListener);

	/**
	 * Returns a list of keyPress listener for the component
	 * 
	 * @return keyPress listeners' list
	 */
    FacesListener[] listKeyPressListeners();
}
