/*
 * $Id: ILoadEventCapability.java,v 1.5 2006/12/14 16:59:33 flefevere Exp $
 * 
 */

package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.ILoadListener;


/**
 *
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/14 16:59:33 $
 */
public interface ILoadEventCapability {

	/**
	 * Adds a listener to the component for the load event
	 * 
	 * @param facesListener the load listener to add 
	 */
    void addLoadListener(ILoadListener loadListener);

	/**
	 * Removes a listener from the component for the load event
	 * 
	 * @param facesListener the load listener to remove
	 */
    void removeLoadListener(ILoadListener loadListener);

	/**
	 * Returns a list of load listener for the component
	 * 
	 * @return load listeners' list
	 */
    FacesListener[] listLoadListeners();
}
