/*
 * $Id: IOrientationCapability.java,v 1.5 2006/12/14 16:59:33 flefevere Exp $
 *
 */
package org.rcfaces.core.component.capability;

/**
 * A string value specifying the orientation of the component :
 *		<ul><li>
 *		horizontal (default value)
 *		</li><li>
 *		vertical
 *		</li></ul>
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/14 16:59:33 $
 */
public interface IOrientationCapability {

	/**
	 * Returns a string value specifying the orientation of the component.
	 * @return horizontal|vertical
	 */
	String getOrientation();

	/**
	 * Sets a string value specifying the orientation of the component.
	 * @param orientation horizontal|vertical
	 */
	void setOrientation(String orientation);

}
