/*
 * $Id: ISelectionCardinalityCapability.java,v 1.3 2006/12/14 16:59:34 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * An int value specifying the type of multiple selection authorized:
 *		<ul><li>
 *		1:optionnal|?: none or one selection
 *		</li><li>
 *		2:zeromany|*: any number of selections or none
 *		</li><li>
 *		3:one|1: one and only one selection
 *		</li><li>
 *		4:onemany|+: one or more selection
 *		</li></ul>
 *
 *	cf. ICardinality for constant values
 *
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.3 $ $Date: 2006/12/14 16:59:34 $
 */
public interface ISelectionCardinalityCapability extends ICardinality {

    /**
     * Returns an int value specifying the type of multiple selection authorized.
     * cf. ICardinality for constant values
     * @return 1: none or one selection|2: any number of selections or none|3: one and only one selection|4: one or more selection
     */
	int getSelectionCardinality();

	/**
	 * Sets an int value specifying the type of multiple selection authorized.
	 * cf. ICardinality for constant values
	 * @param selectionCardinality 1: none or one selection|2: any number of selections or none|3: one and only one selection|4: one or more selection
	 */
    void setSelectionCardinality(int selectionCardinality);
}
