/*
 * $Id: ISelectionEventCapability.java,v 1.5 2006/12/14 16:59:34 flefevere Exp $
 */

package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.ISelectionListener;

/**
 * 
 * 
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.5 $ $Date: 2006/12/14 16:59:34 $
 */
public interface ISelectionEventCapability {

	/**
	 * Adds a listener to the component for the selection event
	 * 
	 * @param facesListener the selection listener to add 
	 */
    void addSelectionListener(ISelectionListener facesListener);

	/**
	 * Removes a listener from the component for the selection event
	 * 
	 * @param facesListener the selection listener to remove
	 */
    void removeSelectionListener(ISelectionListener facesListener);

	/**
	 * Returns a list of selection listener for the component
	 * 
	 * @return selection listeners' list
	 */
    FacesListener[] listSelectionListeners();
}