/*
 * $Id: IServiceEventCapability.java,v 1.4 2006/12/14 16:59:34 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.IServiceEventListener;

/**
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/14 16:59:34 $
 */
public interface IServiceEventCapability {

	/**
	 * Adds a listener to the component for the service event
	 * 
	 * @param facesListener the service listener to add 
	 */
	void addServiceEventListener(IServiceEventListener facesListener);

	/**
	 * Removes a listener from the component for the service event
	 * 
	 * @param facesListener the service listener to remove
	 */
    void removeServiceEventListener(IServiceEventListener facesListener);

	/**
	 * Returns a list of service listener for the component
	 * 
	 * @return service listeners' list
	 */
    FacesListener[] listServiceEventListeners();

}
