/*
 * $Id: IStyleClassCapability.java,v 1.4 2006/12/15 14:12:34 flefevere Exp $
 */
package org.rcfaces.core.component.capability;

/**
 * A space-separated list of CSS style class(es) to be applied to the component. This value will be passed through as the "class" attribute on generated markup.
 *  
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/15 14:12:34 $
 */
public interface IStyleClassCapability {

    /**
     * Specify the style class of the component.
     * @param cssClass style class
     */
    void setStyleClass(String cssClass);

    /**
     * Returns the style class of the component.
     * @return style class
     */
    String getStyleClass();

}