/*
 * $Id: ISuggestionEventCapability.java,v 1.4 2006/12/15 14:12:34 flefevere Exp $
 * 
 */

package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.ISuggestionListener;


/**
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/15 14:12:34 $
 */
public interface ISuggestionEventCapability {

	/**
	 * Adds a listener to the component for the suggestion event
	 * 
	 * @param facesListener the suggestion listener to add 
	 */
    void addSuggestionListener(ISuggestionListener siggestionListener);

	/**
	 * Removes a listener from the component for the suggestion event
	 * 
	 * @param facesListener the suggestion listener to remove
	 */
    void removeSuggestionListener(ISuggestionListener siggestionListener);

	/**
	 * Returns a list of suggestion listener for the component
	 * 
	 * @return suggestion listeners' list
	 */
    FacesListener[] listSuggestionListeners();
}
