/*
 * $Id: IUserEventCapability.java,v 1.4 2006/12/15 14:12:34 flefevere Exp $
 * 
 */
package org.rcfaces.core.component.capability;

import javax.faces.event.FacesListener;

import org.rcfaces.core.event.IUserEventListener;


/**
 * @author Olivier Oeuillot (latest modification by $Author: flefevere $)
 * @version $Revision: 1.4 $ $Date: 2006/12/15 14:12:34 $
 */
public interface IUserEventCapability {

	/**
	 * Adds a listener to the component for the user event
	 * 
	 * @param facesListener the user listener to add 
	 */
	void addUserEventListener(IUserEventListener facesListener);

	/**
	 * Removes a listener from the component for the user event
	 * 
	 * @param facesListener the user listener to remove
	 */
    void removeUserEventListener(IUserEventListener facesListener);

	/**
	 * Returns a list of user listener for the component
	 * 
	 * @return user listeners' list
	 */
    FacesListener[] listUserEventListeners();

}
