/*
 * $Id: ByteConverter.java,v 1.1 2006/10/13 18:04:51 oeuillot Exp $
 */
package org.rcfaces.core.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.1 $ $Date: 2006/10/13 18:04:51 $
 */
public class ByteConverter extends AbstractNumberConverter {
    private static final String REVISION = "$Revision: 1.1 $";

    public ByteConverter() {
        setIntegerOnly(true);
        setMaxFractionDigits(3);
    }

    public Object getAsObject(FacesContext context, UIComponent component,
            String value) {

        if (value == null || value.trim().length() < 1) {
            Object v = getDefaultValue();
            if (v instanceof Byte) {
                return v;
            }
            if (v instanceof Number) {
                return new Byte(((Number) v).byteValue());
            }
            value = (String) v;
        }

        Number number = (Number) super.getAsObject(context, component, value);

        if (number == null || (number instanceof Byte)) {
            return number;
        }

        long l = number.longValue();
        if (l < Byte.MIN_VALUE || l > Byte.MAX_VALUE) {
            throw new ConverterException(
                    "Number can not be converted to byte. (value=" + l + ")");
        }

        return new Byte(number.byteValue());
    }
}
