/*
 * $Id: DoubleConverter.java,v 1.1 2006/10/13 18:04:51 oeuillot Exp $
 */
package org.rcfaces.core.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.1 $ $Date: 2006/10/13 18:04:51 $
 */
public class DoubleConverter extends AbstractNumberConverter {
    private static final String REVISION = "$Revision: 1.1 $";

    public DoubleConverter() {
        setIntegerOnly(false);
    }

    public Object getAsObject(FacesContext context, UIComponent component,
            String value) {

        if (value == null || value.trim().length() < 1) {
            Object v = getDefaultValue();
            if (v instanceof Double) {
                return v;
            }
            if (v instanceof Number) {
                return new Double(((Number) v).doubleValue());
            }
            value = (String) v;
        }

        Number number = (Number) super.getAsObject(context, component, value);

        if (number == null || (number instanceof Double)) {
            return number;
        }

        return new Double(number.doubleValue());
    }
}
