/*
 * $Id: CameliaEvent.java,v 1.3 2006/11/10 14:15:47 oeuillot Exp $
 * 
 */
package org.rcfaces.core.event;

import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;

import org.rcfaces.core.internal.listener.IScriptListener;


/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/10 14:15:47 $
 */
abstract class CameliaEvent extends FacesEvent implements ITypedEvent {
	private static final String REVISION = "$Revision: 1.3 $";

	protected final int type;

	public CameliaEvent(UIComponent component) {
		this(component, 0);
	}

	public CameliaEvent(UIComponent component, int type) {
		super(component);

		this.type = type;
	}

	public final int getType() {
		return type;
	}

	public boolean isAppropriateListener(FacesListener listener) {
		if (listener instanceof IScriptListener) {
			return false;
		}

		return true;
	}

}
