/*
 * $Id: TemplatesEngine.java,v 1.4 2006/12/18 13:30:29 oeuillot Exp $
 */
package org.rcfaces.core.internal.component;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import org.rcfaces.core.internal.Constants;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.4 $ $Date: 2006/12/18 13:30:29 $
 */
public class TemplatesEngine implements PhaseListener {
    private static final String REVISION = "$Revision: 1.4 $";

    private static final long serialVersionUID = -6370096499604012889L;

    private static final ThreadLocal templateConstructPhase;
    static {
        if (Constants.TEMPLATE_ENGINE_SUPPORT) {
            templateConstructPhase = new ThreadLocal();
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (Constants.TEMPLATE_ENGINE_SUPPORT == false) {
            return;
        }

        templateConstructPhase.set(null);
    }

    public void beforePhase(PhaseEvent event) {
        if (Constants.TEMPLATE_ENGINE_SUPPORT == false) {
            return;
        }

        templateConstructPhase.set(Boolean.TRUE);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public static boolean isConstructPhase() {
        if (Constants.TEMPLATE_ENGINE_SUPPORT == false) {
            return false;
        }

        return templateConstructPhase.get() == null;
    }
}
