/*
 * $Id: IContentAccessor.java,v 1.3 2006/11/13 11:31:51 oeuillot Exp $
 */
package org.rcfaces.core.internal.contentAccessor;

import java.util.Map;

import javax.faces.context.FacesContext;

import org.rcfaces.core.model.IFilterProperties;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/13 11:31:51 $
 */
public interface IContentAccessor {

    String FILTER_SEPARATOR = "::";

    int UNDEFINED_PATH_TYPE = 0;

    int RELATIVE_PATH_TYPE = 1;

    int CONTEXT_PATH_TYPE = 2;

    int ABSOLUTE_PATH_TYPE = 3;

    int EXTERNAL_PATH_TYPE = 4;

    int FILTER_PATH_TYPE = 5;

    IContentType getType();

    int getPathType();

    void setPathType(int pathType);

    Object getAttribute(String attributeName);

    Map getAttributes();

    Object getContentRef();

    String resolveURL(FacesContext facesContext,
            IContentInformation contentInformation,
            IFilterProperties filterProperties);

    IContentAccessor getParentAccessor();

    IContentVersionHandler getContentVersionHandler();

    void setContentVersionHandler(IContentVersionHandler contentVersionHandler);
}
