/*
 * $Id: TextPositionConverter.java,v 1.3 2006/11/10 14:15:48 oeuillot Exp $
 * 
 */
package org.rcfaces.core.internal.converter;

import java.util.HashMap;
import java.util.Map;

import javax.faces.convert.Converter;

import org.rcfaces.core.component.capability.IHorizontalTextPositionCapability;
import org.rcfaces.core.component.capability.ITextPositionCapability;


/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/10 14:15:48 $
 */
public class TextPositionConverter extends HorizontalTextPositionConverter {
    private static final String REVISION = "$Revision: 1.3 $";

    public static final Converter SINGLETON = new TextPositionConverter();

    private static final String TOP_POSITION_NAME = "top";

    private static final String BOTTOM_POSITION_NAME = "bottom";

    private static final Integer DEFAULT_POSITION = new Integer(
            IHorizontalTextPositionCapability.DEFAULT_POSITION);

    private static Map TEXT_POSITIONS = new HashMap(5);
    static {
        Integer i = new Integer(ITextPositionCapability.BOTTOM_POSITION);
        TEXT_POSITIONS.put(BOTTOM_POSITION_NAME, i);

        i = new Integer(IHorizontalTextPositionCapability.LEFT_POSITION);
        TEXT_POSITIONS.put(LEFT_POSITION_NAME, i);

        i = new Integer(ITextPositionCapability.TOP_POSITION);
        TEXT_POSITIONS.put(TOP_POSITION_NAME, i);

        i = new Integer(IHorizontalTextPositionCapability.RIGHT_POSITION);
        TEXT_POSITIONS.put(RIGHT_POSITION_NAME, i);
    }

    protected Map getTextPositions() {
        return TEXT_POSITIONS;
    }

    protected Integer getDefaultPosition() {
        return DEFAULT_POSITION;
    }
}
