/*
 * $Id: ValidationParameterHandler.java,v 1.1 2006/11/22 18:01:33 oeuillot Exp $
 */
package org.rcfaces.core.internal.facelets;

import javax.faces.component.UIComponent;

import org.rcfaces.core.internal.manager.IValidationParameters;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.LegacyValueBinding;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.tag.TagHandler;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.1 $ $Date: 2006/11/22 18:01:33 $
 */
public class ValidationParameterHandler extends TagHandler {
    private static final String REVISION = "$Revision: 1.1 $";

    private final TagAttribute name;

    private final TagAttribute value;

    private final TagAttribute clientSide;

    public ValidationParameterHandler(TagConfig config) {
        super(config);
        this.name = this.getRequiredAttribute("name");
        this.value = this.getRequiredAttribute("value");
        this.clientSide = this.getAttribute("clientSide");
    }

    public void apply(FaceletContext ctx, UIComponent parent) {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }

        // only process if the parent is new to the tree
        if (parent.getParent() != null) {
            return;
        }

        boolean clientSide = value.getBoolean(ctx);

        IValidationParameters clientDataCapability = (IValidationParameters) parent;

        String nameValue = name.getValue(ctx);
        if (value.isLiteral()) {
            clientDataCapability.setValidationParameter(nameValue, value
                    .getValue(), clientSide);
            return;
        }

        clientDataCapability.setValidationParameter(nameValue,
                new LegacyValueBinding(value.getValueExpression(ctx,
                        String.class)), clientSide);
    }

}
