/*
 * $Id: Constants.java,v 1.5 2006/12/08 17:26:06 oeuillot Exp $
 */
package org.rcfaces.core.internal.images;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.5 $ $Date: 2006/12/08 17:26:06 $
 */
public class Constants {
    private static final String REVISION = "$Revision: 1.5 $";

    private static final Log LOG = LogFactory.getLog(Constants.class);

    private static final boolean USE_INCLUDE_IMAGE_LOADER_FACTORY = true;

    private static final String CONSTANT_PREFIX;
    static {
        String name = Constants.class.getPackage().getName();
        if (name.endsWith(".internal")) {
            name = name.substring(0, name.lastIndexOf('.'));
        }

        CONSTANT_PREFIX = name;
    }

    private static final IImageLoaderFactory DESIGNER_IMAGE_LOADER_FACTORY = new ResourceImageLoaderFactory();

    private static final IImageLoaderFactory IMAGE_LOADER_FACTORY;

    static {

        if (USE_INCLUDE_IMAGE_LOADER_FACTORY) {
            IMAGE_LOADER_FACTORY = new IncludeImageLoaderFactory();

        } else {
            IMAGE_LOADER_FACTORY = DESIGNER_IMAGE_LOADER_FACTORY;
        }

        LOG.info("USE_INCLUDE_IMAGE_LOADER_FACTORY="
                + USE_INCLUDE_IMAGE_LOADER_FACTORY + " ("
                + IMAGE_LOADER_FACTORY.getName() + ")");
    }

    public static final String getPackagePrefix() {
        return CONSTANT_PREFIX;
    }

    public static final IImageLoaderFactory getImageLoaderFactory() {
        return IMAGE_LOADER_FACTORY;
    }

    public static final IImageLoaderFactory getDesignerImageLoaderFactory() {
        return DESIGNER_IMAGE_LOADER_FACTORY;
    }
}
