/*
 * $Id: AbstractActionListener.java,v 1.4 2006/11/10 14:15:47 oeuillot Exp $
 * 
 */
package org.rcfaces.core.internal.listener;

import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rcfaces.core.internal.util.ForwardMethodBinding;


/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.4 $ $Date: 2006/11/10 14:15:47 $
 */
abstract class AbstractActionListener implements StateHolder,
        IServerActionListener {
    private static final String REVISION = "$Revision: 1.4 $";

    private static final Log LOG = LogFactory
            .getLog(AbstractActionListener.class);

    private static final Class[] FACES_PARAMETERS = new Class[] { FacesEvent.class };

    private String expression;

    private transient boolean forwarNameMethodInitialized;

    private transient MethodBinding forwardNameMethodBinding;

    private transient boolean argsMethodBindingInitialized;

    private transient MethodBinding argsMethodBinding;

    private transient boolean noArgsMethodBindingInitialized;

    private transient MethodBinding noArgsMethodBinding;

    private transient boolean facesArgsMethodBindingInitialized;

    private transient MethodBinding facesArgsMethodBinding;

    private boolean transientValue;

    protected AbstractActionListener() {
        // Pour la deserialisation
    }

    protected AbstractActionListener(String expression) {
        this.expression = expression;
    }

    /*
     * public final MethodBinding getMethodBinding() { return methodBinding; }
     */
    protected void process(FacesEvent event) throws AbortProcessingException {

        FacesContext facesContext = getFacesContext();
        Application application = facesContext.getApplication();

        if (forwarNameMethodInitialized == false) {
            forwarNameMethodInitialized = true;

            String forwardName = getForwardName(expression);
            if (forwardName != null) {
                forwardNameMethodBinding = getNoArgsMethodBinding(application);
            }
        }

        if (forwardNameMethodBinding != null) {
            MethodNotFoundException th = tryMethodBinding(facesContext,
                    forwardNameMethodBinding, null, event);

            if (th == null) {
                return;
            }

            throw th;
        }

        Object parameters[] = new Object[] { event };
        MethodNotFoundException firstThrowable = null;

        if (argsMethodBindingInitialized == false) {
            argsMethodBindingInitialized = true;
            argsMethodBinding = getArgumentsMethodBinding(application);
        }
        if (argsMethodBinding != null) {
            MethodNotFoundException th = tryMethodBinding(facesContext,
                    argsMethodBinding, parameters, event);
            if (th == null) {
                return;
            }
            firstThrowable = th;
        }

        if (facesArgsMethodBindingInitialized == false) {
            facesArgsMethodBindingInitialized = true;
            facesArgsMethodBinding = getFacesArgumentsMethodBinding(application);
        }
        if (facesArgsMethodBinding != null) {
            MethodNotFoundException th = tryMethodBinding(facesContext,
                    facesArgsMethodBinding, parameters, event);
            if (th == null) {
                return;
            }
            if (firstThrowable == null) {
                firstThrowable = th;
            }
        }

        if (noArgsMethodBindingInitialized == false) {
            noArgsMethodBindingInitialized = true;
            noArgsMethodBinding = getNoArgsMethodBinding(application);
        }
        if (noArgsMethodBinding != null) {
            MethodNotFoundException th = tryMethodBinding(facesContext,
                    noArgsMethodBinding, null, event);
            if (th == null) {
                return;
            }
            if (firstThrowable == null) {
                firstThrowable = th;
            }
        }
    }

    private MethodNotFoundException tryMethodBinding(FacesContext facesContext,
            MethodBinding methodBinding, Object parameters[], FacesEvent event) {

        try {
            Object ret = methodBinding.invoke(facesContext, parameters);

            processReturn(facesContext, methodBinding, event, ret);

            return null;

        } catch (MethodNotFoundException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method not found for expression '" + expression
                        + "'.", ex);
            }

            return ex;

        } catch (EvaluationException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evaluation error for expression '" + expression
                        + "'.", ex);
            }

            Throwable cause = ex.getCause();

            if (cause instanceof AbortProcessingException) {
                throw (AbortProcessingException) cause;
            }

            throw ex;
        }
    }

    private MethodBinding getArgumentsMethodBinding(Application application) {
        return application.createMethodBinding(expression, FACES_PARAMETERS);
    }

    private MethodBinding getFacesArgumentsMethodBinding(Application application) {
        return application.createMethodBinding(expression,
                listParameterClasses());
    }

    private MethodBinding getNoArgsMethodBinding(Application application) {
        return application.createMethodBinding(expression, null);
    }

    protected abstract Class[] listParameterClasses();

    private MethodBinding getForwardMethodBinding() {
        forwarNameMethodInitialized = true;

        noArgsMethodBinding = new ForwardMethodBinding(expression);
        return noArgsMethodBinding;
    }

    protected static final String getForwardName(String expression) {
        int len = expression.length() - 1;

        if (len < 3) {
            return null;
        }

        if (expression.startsWith("#[") == false) {
            return null;
        }

        if (expression.charAt(len) != ']') {
            return null;
        }

        return expression.substring(2, len);
    }

    protected final FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    /*
     * (non-Javadoc)
     * 
     * 
     * ee javax.faces.component.StateHolder#isTransient()
     */
    public boolean isTransient() {
        return transientValue;
    }

    /*
     * (non-Javadoc)
     * 
     * 
     * ee javax.faces.component.StateHolder#setTransient(boolean)
     */
    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }

    /*
     * (non-Javadoc)
     * 
     * 
     * ee
     * javax.faces.component.StateHolder#restoreState(javax.faces.context.FacesContext,
     * java.lang.Object)
     */
    public final void restoreState(FacesContext context, Object state) {
        Object objects[] = (Object[]) state;

        expression = (String) objects[0];
        if (expression == null) {
            throw new NullPointerException("Expression is null !");
        }

        forwarNameMethodInitialized = false;
    }

    /*
     * (non-Javadoc)
     * 
     * 
     * ee
     * javax.faces.component.StateHolder#saveState(javax.faces.context.FacesContext)
     */
    public final Object saveState(FacesContext context) {
        Object objects[] = new Object[1];

        objects[0] = expression;
        if (expression == null) {
            throw new NullPointerException("Expression is NULL");
        }

        return objects;
    }

    protected void processReturn(FacesContext facesContext,
            MethodBinding binding, FacesEvent event, Object ret) {
        if ((ret instanceof String) == false) {
            return;
        }

        String outcome = (String) ret;

        NavigationHandler navHandler = facesContext.getApplication()
                .getNavigationHandler();

        navHandler.handleNavigation(facesContext,
                binding.getExpressionString(), outcome);

        facesContext.renderResponse();
    }

    public boolean equals(Object object) {
        if (object == null
                || (object instanceof AbstractActionListener) == false) {
            return false;
        }

        AbstractActionListener s = (AbstractActionListener) object;

        if (expression != s.expression) {
            if (expression == null || expression.equals(s.expression) == false) {
                return false;
            }
        }

        return true;
    }

    public int hashCode() {
        if (expression == null) {
            return 0;
        }

        return expression.hashCode();
    }

}
