/*
 * $Id: AbstractComponentRenderContext.java,v 1.3 2006/10/13 18:04:51 oeuillot Exp $
 */
package org.rcfaces.core.internal.renderkit;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/10/13 18:04:51 $
 */
public abstract class AbstractComponentRenderContext implements
        IComponentRenderContext {
    private static final String REVISION = "$Revision: 1.3 $";

    private final UIComponent component;

    private final String componentClientId;

    private FacesContext facesContext;

    private Map attributes;

    protected AbstractComponentRenderContext(FacesContext facesContext,
            UIComponent component, String componentClientId) {
        this.facesContext = facesContext;
        this.component = component;
        this.componentClientId = componentClientId;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.rcfaces.core.internal.renderkit.IComponentRenderContext#getFacesContext()
     */
    public final FacesContext getFacesContext() {
        if (facesContext == null) {
            facesContext = FacesContext.getCurrentInstance();
        }
        return facesContext;
    }

    public final UIComponent getComponent() {
        return component;
    }

    public final String getComponentClientId() {
        return componentClientId;
    }

    public Object getAttribute(String key) {
        if (attributes == null) {
            return null;
        }

        return attributes.get(key);
    }

    public boolean containsAttribute(String key) {
        if (attributes == null) {
            return false;
        }

        return attributes.containsKey(key);
    }

    public Object setAttribute(String key, Object value) {
        if (attributes == null) {
            attributes = new HashMap();
        }

        return attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        if (attributes == null) {
            return null;
        }

        return attributes.remove(key);
    }

}
