/*
 * $Id: AbstractAsyncRenderService.java,v 1.4 2006/11/10 14:00:05 oeuillot Exp $
 */
package org.rcfaces.core.internal.service;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKitFactory;
import javax.servlet.jsp.tagext.BodyContent;

import org.rcfaces.core.internal.Constants;
import org.rcfaces.core.internal.RcfacesContext;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.4 $ $Date: 2006/11/10 14:00:05 $
 */
public abstract class AbstractAsyncRenderService implements IService {
    private static final String REVISION = "$Revision: 1.4 $";

    private static final String SERVICE_ID = Constants.getPackagePrefix()
            + ".AsyncRender";

    public static AbstractAsyncRenderService getInstance(
            FacesContext facesContext) {

        IServicesRegistry serviceRegistry = RcfacesContext.getInstance(
                facesContext).getServicesRegistry();
        if (serviceRegistry == null) {
            // Designer mode
            return null;
        }

        return (AbstractAsyncRenderService) serviceRegistry.getService(
                facesContext, RenderKitFactory.HTML_BASIC_RENDER_KIT,
                SERVICE_ID);
    }

    public abstract boolean isAsyncRenderEnable();

    public abstract boolean isAsyncRendererEnabled(FacesContext facesContext,
            UIComponent component);

    public abstract void setContent(FacesContext facesContext,
            UIComponent componentInstance, BodyContent bodyContent);
}
