/*
 * $Id: AbstractService.java,v 1.3 2006/11/10 14:00:05 oeuillot Exp $
 */
package org.rcfaces.core.internal.service;

import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/10 14:00:05 $
 */
public abstract class AbstractService implements IService {
    private static final String REVISION = "$Revision: 1.3 $";

    // private static final Log LOG = LogFactory.getLog(AbstractService.class);

    protected static Renderer getRenderer(FacesContext facesContext,
            UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            return null;
        }

        RenderKitFactory rkFactory = (RenderKitFactory) FactoryFinder
                .getFactory(FactoryFinder.RENDER_KIT_FACTORY);
        RenderKit renderKit = rkFactory.getRenderKit(facesContext, facesContext
                .getViewRoot().getRenderKitId());

        return renderKit.getRenderer(component.getFamily(), rendererType);
    }
}