/*
 * $Id: TimeTools.java,v 1.3 2006/12/08 17:26:06 oeuillot Exp $
 */
package org.rcfaces.core.internal.tools;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.rcfaces.core.internal.renderkit.IComponentRenderContext;
import org.rcfaces.core.model.Time;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/12/08 17:26:06 $
 */
public class TimeTools {
    private static final String REVISION = "$Revision: 1.3 $";

    public static Object parseValue(FacesContext context,
            UIComponent component, String value) {

        DateFormat dateFormat = getShortTimeFormat(component);

        Date d;
        try {
            synchronized (dateFormat) {
                d = dateFormat.parse(value);

                return new Time(d, dateFormat.getCalendar());
            }

        } catch (ParseException e) {
            throw new FacesException("Can not parse time '" + value + "'.", e);
        }
    }

    public static String formatValue(UIComponent component, Time time) {
        DateFormat dateFormat = getShortTimeFormat(component);

        synchronized (dateFormat) {
            Date date = time.getDate(dateFormat.getCalendar());

            return dateFormat.format(date);
        }
    }

    private static DateFormat getShortTimeFormat(UIComponent component) {
        return (DateFormat) LocaleTools.getDefaultFormat(component, LocaleTools.TIME_TYPE);
    }

    public static String getDefaultTimeFormatPattern(Locale locale) {
        return LocaleTools.getDefaultPattern(locale, LocaleTools.TIME_TYPE);
    }

    public static String normalizeTimeFormat(
            IComponentRenderContext componentRenderContext, String format) {
        return LocaleTools.normalizeFormat(componentRenderContext, format,
                LocaleTools.TIME_TYPE, Collections.EMPTY_MAP);
    }

}
