/*
 * $Id: ForwardMethodBinding.java,v 1.3 2006/11/10 14:15:47 oeuillot Exp $
 * 
 */
package org.rcfaces.core.internal.util;

import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/10 14:15:47 $
 */
public class ForwardMethodBinding extends MethodBinding implements StateHolder {
	private static final String REVISION="$Revision: 1.3 $";
	
	private String forward = null;

	public ForwardMethodBinding() {
	}

	public ForwardMethodBinding(String forward) {
		this.forward = forward;
	}

	public Object invoke(FacesContext context, Object params[]) {
		return forward;
	}

	public Class getType(FacesContext context) {
		return String.class;
	}

	// ----------------------------------------------------- StateHolder Methods

	public Object saveState(FacesContext context) {
		return forward;
	}

	public void restoreState(FacesContext context, Object state) {
		forward = (String) state;
	}

	private boolean transientFlag = false;

	public boolean isTransient() {
		return (this.transientFlag);
	}

	public void setTransient(boolean transientFlag) {
		this.transientFlag = transientFlag;
	}
}
