/*
 * $Id: IHierarchicalRepository.java,v 1.3 2006/11/14 10:52:16 oeuillot Exp $
 * 
 */
package org.rcfaces.core.internal.webapp;

import java.util.Collection;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/14 10:52:16 $
 */
public interface IHierarchicalRepository extends IRepository {

    int FILE_COLLECTION_TYPE = 0;

    int FILENAME_COLLECTION_TYPE = 1;

    IHierarchicalFile[] computeFiles(Collection collection,
            int typeOfCollection, IContext context);

    IModule[] listModules();

    IModule getModuleByName(String name);

    ISet getBootSet();

    ISet getSetByName(String bootSet);

    void setBootSet(ISet set);

    ISet declareSet(String name, String uri, String[] moduleNames);

    /**
     * 
     * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
     * @version $Revision: 1.3 $ $Date: 2006/11/14 10:52:16 $
     */
    public interface IHierarchicalFile extends IFile {

        IHierarchicalFile[] listDependencies();

        IModule getModule();
    }

    /**
     * 
     * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
     * @version $Revision: 1.3 $ $Date: 2006/11/14 10:52:16 $
     */
    public interface ISet extends IHierarchicalFile {
        IHierarchicalFile[] listExternalDependencies();
    }

    /**
     * 
     * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
     * @version $Revision: 1.3 $ $Date: 2006/11/14 10:52:16 $
     */
    public interface IModule extends IHierarchicalFile {
        boolean getGroupAllFiles();

        void setGroupAllFiles(boolean enable);

        boolean isDefaultCoreModule();

        void setDefaultCoreModule();

        IHierarchicalFile[] listExternalDependencies();

        IModule[] listExternalModules();

        ISet getSet();
    }
}
