/*
 * $Id: DefaultSortedComponent.java,v 1.2 2006/09/14 14:34:51 oeuillot Exp 
 */
package org.rcfaces.core.model;

import javax.faces.component.UIComponent;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/10/13 18:04:50 $
 */
public class DefaultSortedComponent implements ISortedComponent {
    private static final String REVISION = "$Revision: 1.3 $";

    private final UIComponent component;

    private final int index;

    private final int sortMode;

    public DefaultSortedComponent(UIComponent component, int index, int sortMode) {
        this.component = component;
        this.index = index;
        this.sortMode = sortMode;
    }

    public DefaultSortedComponent(UIComponent component, int index,
            boolean sortOrder) {
        this(component, index, (sortOrder) ? ASCENDING : DESCENDING);
    }

    public UIComponent getComponent() {
        return component;
    }

    public int getIndex() {
        return index;
    }

    public int getSortMode() {
        return sortMode;
    }

    public final boolean isAscending() {
        return getSortMode() == ASCENDING;
    }

}
