/*
 * $Id: IIndexesModel.java,v 1.3 2006/10/13 18:04:50 oeuillot Exp $
 */
package org.rcfaces.core.model;


/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/10/13 18:04:50 $
 */
public interface IIndexesModel {
	
	/**
	 * Number of selected items.
	 */
	int countIndexes();
	
	/**
	 * List all indexes sorted by ascendending.
	 */
	int [] listSortedIndexes(); 

	/**
	 * Returns the first index.
	 */
	int getFirstIndex();

	/**
	 * Clear all selection.
	 */
	void clearIndexes();

	/**
	 * Specify the indexes of selected items.
	 */
	void setIndexes(int indexes[]);
	
	/**
	 * Returns if the index of item is selected.
	 */
	boolean containsIndex(int index);

	void addIndex(int index);
	
	void removeIndex(int index);
	
	void commitChanges();
	
	Object [] listSelectedObjects(Object toArray[], Object value);

	Object getFirstSelectedObject(Object cachedValue);
}
