/*
 * $Id: ImageContentInformation.java,v 1.2 2006/11/14 10:52:16 oeuillot Exp $
 */
package org.rcfaces.core.model;

import org.rcfaces.core.internal.contentAccessor.BasicContentInformation;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.2 $ $Date: 2006/11/14 10:52:16 $
 */
public class ImageContentInformation extends BasicContentInformation {
    private static final String REVISION = "$Revision: 1.2 $";

    public final int getImageHeight() {
        Integer i = (Integer) getAttribute(IContentModel.HEIGHT_PROPERTY);
        if (i == null) {
            return 0;
        }

        return i.intValue();
    }

    public final void setImageHeight(int imageHeight) {
        setAttribute(IContentModel.HEIGHT_PROPERTY, new Integer(imageHeight));
    }

    public final int getImageWidth() {
        Integer i = (Integer) getAttribute(IContentModel.WIDTH_PROPERTY);
        if (i == null) {
            return 0;
        }

        return i.intValue();
    }

    public final void setImageWidth(int imageWidth) {
        setAttribute(IContentModel.WIDTH_PROPERTY, new Integer(imageWidth));
    }

}
