/*
 * $Id: MapIndexesModel.java,v 1.3 2006/10/13 18:04:50 oeuillot Exp $
 */
package org.rcfaces.core.model;

import java.util.Map;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/10/13 18:04:50 $
 */
public class MapIndexesModel extends CollectionIndexesModel {

    private static final String REVISION = "$Revision: 1.3 $";

    private static final long serialVersionUID = -6123923382601149193L;

    private static final Object DEFAULT_VALUE = Boolean.TRUE;

    private final Map map;

    private final Object defaultValue;

    public MapIndexesModel(Map map) {
        this(map, DEFAULT_VALUE);
    }

    public MapIndexesModel(Map map, Object defaultValue) {
        super(map.keySet());

        this.map = map;
        this.defaultValue = defaultValue;
    }

    public void addIndex(int index) {
        map.put(getKey(index), getSelectedValue(index));
    }

    protected Object getSelectedValue(int index) {
        return defaultValue;
    }
}
