/*
 * $Id: AbstractProvider.java,v 1.5 2006/11/13 11:01:15 oeuillot Exp $
 * 
 */
package org.rcfaces.core.provider;

import javax.faces.context.FacesContext;

import org.apache.commons.digester.Digester;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.5 $ $Date: 2006/11/13 11:01:15 $
 */
public abstract class AbstractProvider implements IProvider {
    private static final String REVISION = "$Revision: 1.5 $";

    public void configureRules(Digester digester) {
    }

    public void startup(FacesContext facesContext) {
    }

    public boolean equals(Object obj) {
        if (obj == null || (obj instanceof AbstractProvider) == false) {
            return false;
        }

        return getId().equals(((AbstractProvider) obj).getId());
    }

    public int hashCode() {
        return getId().hashCode();
    }

    public String toString() {
        return "[AbstractProvider '" + getId() + "']";
    }
}
